--
-- Code to call the OLE Automation methods to create a word document from a
-- transact-SQL stored procedure
--

DECLARE @Object      int, 
        @RetCode     int, 
        @Document    int , 
        @Emp         varchar(255),
        @Method      varchar(255),
        @ErrorSource varchar(255),
        @ErrorDesc   varchar(255),
        @Filename    varchar(255)

DECLARE emp_cursor CURSOR FOR
SELECT LastName + ', ' + CHAR(9) + FirstName + CHAR(9) + CHAR(9) + Title
FROM Employees
ORDER BY LastName

EXEC @RetCode = sp_OACreate 'Word.Application', @Object OUTPUT, 4
If @RetCode <> 0 Goto OLE_Error_Handler

EXEC @RetCode = sp_OAMethod @Object, 'Documents.Add', @Document OUTPUT
If @RetCode <> 0 Goto OLE_Error_Handler

EXEC sp_OASetProperty @Object,'Selection.Font.Name', 'Arial'

EXEC sp_OASetProperty @Object,'Selection.Font.Size', 20

EXEC sp_OAMethod @Object,
        'Selection.TypeText("Sample Employee Report")'

EXEC sp_OAMethod @Object,'Selection.TypeParagraph'

EXEC sp_OASetProperty @Object,'Selection.Font.Size', 8

EXEC sp_OAMethod @Object,'Selection.TypeText("(This report generated by SQL Server)")'

EXEC sp_OAMethod @Object,'Selection.TypeParagraph'

EXEC sp_OAMethod @Object,'Selection.TypeParagraph'

EXEC sp_OASetProperty @Object,'Selection.Font.Size', 12

OPEN emp_cursor

FETCH NEXT FROM emp_cursor into @Emp

WHILE @@FETCH_STATUS = 0
BEGIN

   SELECT @Method = 'Selection.TypeText("' + @Emp + '")' 

   EXEC sp_OAMethod @Object, @Method
   EXEC sp_OAMethod @Object,'Selection.TypeParagraph'

   FETCH NEXT FROM emp_cursor into @Emp
END

CLOSE emp_cursor
DEALLOCATE emp_cursor

SELECT @Filename = 'C:\EmployeeList.doc'

EXEC @RetCode = sp_OAMethod @Object, 'ActiveDocument.SaveAs' , NULL , @Filename
If @RetCode <> 0 Goto OLE_Error_Handler

EXEC @RetCode = sp_OAMethod @Object, 'Quit'
EXEC sp_OADestroy @Object
Goto Done

OLE_Error_Handler:
    EXEC sp_OAGetErrorInfo @Object, @ErrorSource OUT, @ErrorDesc OUT
    PRINT 'Error Occurred Calling Object:  ' + @ErrorSource + ' ' + @ErrorDesc

    EXEC @RetCode = sp_OAMethod @Object, 'Quit'
    EXEC sp_OADestroy @Object
    Goto Done

Done:
EXEC sp_OAStop
go
